/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.appid;

import android.content.Context;
import com.amazon.identity.auth.device.appid.APIKeyDecoder;
import com.amazon.identity.auth.device.appid.AbstractAppIdentifier;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.utils.MAPLog;

public final class ThirdPartyAppIdentifier
extends AbstractAppIdentifier {
    private static final String LOG_TAG = ThirdPartyAppIdentifier.class.getName();

    @Override
    public String getPackageName(String appId, Context context) {
        return null;
    }

    @Override
    public String[] getPackageNames(String appId, Context context) {
        return null;
    }

    @Override
    public String getPackageNameByVariant(String appVariantId, Context context) {
        return null;
    }

    @Override
    public String getAppFamilyId(String packageName, Context context) {
        MAPLog.i(LOG_TAG, "getAppFamilyId : packageName=" + packageName);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return null;
        }
        AppInfo appInfo = this.getAppInfo(packageName, context);
        return appInfo == null ? null : appInfo.getAppFamilyId();
    }

    @Override
    public String getAppVariantId(String packageName, Context context) {
        MAPLog.i(LOG_TAG, "getAppVariantId : packageName=" + packageName);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return null;
        }
        AppInfo appInfo = this.getAppInfo(packageName, context);
        return appInfo == null ? null : appInfo.getAppVariantId();
    }

    @Override
    public String[] getAllowedScopes(String packageName, Context context) {
        MAPLog.i(LOG_TAG, "getAllowedScopes : packageName=" + packageName);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return null;
        }
        AppInfo appInfo = this.getAppInfo(packageName, context);
        return appInfo == null ? null : appInfo.getAllowedScopes();
    }

    @Override
    public String[] getAppPermissions(String packageName, Context context) {
        MAPLog.i(LOG_TAG, "getAppPermissions : packageName=" + packageName);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return null;
        }
        AppInfo appInfo = this.getAppInfo(packageName, context);
        return appInfo == null ? null : appInfo.getGrantedPermissions();
    }

    public AppInfo getAppInfoByApiKey(String packageName, String apiKey, Context context) {
        MAPLog.i(LOG_TAG, "getAppInfo : packageName=" + packageName);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return null;
        }
        return APIKeyDecoder.doDecode(packageName, apiKey, false, context);
    }

    public boolean isAPIKeyValidFormat(String packageName, String apiKey, Context context) {
        MAPLog.pii(LOG_TAG, "isAPIKeyValid : packageName=" + packageName, "apiKey=" + apiKey);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return false;
        }
        if (apiKey == null) {
            MAPLog.w(LOG_TAG, "apiKey can't be null!");
            return false;
        }
        return APIKeyDecoder.doDecode(packageName, apiKey, false, context) != null;
    }
}

