/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization.api;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.AuthorizationHelper;
import com.amazon.identity.auth.device.authorization.ProfileHelper;
import com.amazon.identity.auth.device.authorization.TokenHelper;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.thread.AuthzCallbackFuture;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.util.Arrays;
import java.util.concurrent.Future;

public class AmazonAuthorizationManager {
    private static final String LOG_TAG = AmazonAuthorizationManager.class.getName();
    private final String mClientId;
    private final Context mContext;
    private final ThirdPartyAppIdentifier mAppIdentifier = new ThirdPartyAppIdentifier();
    private final String SDK_VERSION = "1.0.0";

    public AmazonAuthorizationManager(Context context, Bundle options) {
        AppInfo appInfo;
        MAPLog.pii(LOG_TAG, "AmazonAuthorizationManager:sdkVer=1.0.0 libVer=3.3.0", "options=" + options);
        if (context == null) {
            throw new IllegalArgumentException("context must not be null!");
        }
        this.mContext = context;
        if (options == null) {
            MAPLog.i(LOG_TAG, "Options bundle is null");
        }
        if ((appInfo = this.mAppIdentifier.getAppInfo(this.mContext.getPackageName(), this.mContext)) == null || appInfo.getClientId() == null) {
            throw new IllegalArgumentException("Invalid API Key");
        }
        this.mClientId = appInfo.getClientId();
    }

    public Future<Bundle> authorize(String[] scopes, Bundle options, AuthorizationListener listener) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException("scopes must not be null or empty!");
        }
        return this.authorizeWithBrowser(scopes, listener);
    }

    private Future<Bundle> authorizeWithBrowser(final String[] scopes, final AuthorizationListener listener) {
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling authorize with Activity: scopes=" + Arrays.toString(scopes));
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            @Override
            public void run() {
                if (!AmazonAuthorizationManager.this.isAPIKeyValid()) {
                    listener.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                    return;
                }
                AuthorizationHelper authzHelper = new AuthorizationHelper();
                try {
                    authzHelper.authorize(AmazonAuthorizationManager.this.mContext, AmazonAuthorizationManager.this.mContext.getPackageName(), AmazonAuthorizationManager.this.mClientId, scopes, true, listener);
                }
                catch (AuthError e) {
                    listener.onError(e);
                }
            }
        });
        return null;
    }

    public Future<Bundle> getToken(final String[] scopes, APIListener listener) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException("scopes must not be null or empty!");
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getToken : scopes=" + Arrays.toString(scopes));
        final AuthzCallbackFuture callbackFuture = new AuthzCallbackFuture(listener);
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!AmazonAuthorizationManager.this.isAPIKeyValid()) {
                        callbackFuture.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                        return;
                    }
                    TokenHelper.getToken(AmazonAuthorizationManager.this.mContext, AmazonAuthorizationManager.this.mContext.getPackageName(), AmazonAuthorizationManager.this.mClientId, scopes, new APIListener(){

                        @Override
                        public void onSuccess(Bundle response) {
                            callbackFuture.onSuccess(response);
                        }

                        @Override
                        public void onError(AuthError e) {
                            callbackFuture.onError(e);
                        }
                    });
                }
                catch (AuthError e) {
                    callbackFuture.onError(e);
                }
            }
        });
        return callbackFuture;
    }

    public String getAppId() throws AuthError {
        if (!this.isAPIKeyValid()) {
            throw new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED);
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getAppId");
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        AppInfo appInfo = appIdentifier.getAppInfo(this.mContext.getPackageName(), this.mContext);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getAppFamilyId();
    }

    public String getAppVariantId() throws AuthError {
        if (!this.isAPIKeyValid()) {
            throw new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED);
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getAppId");
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        AppInfo appInfo = appIdentifier.getAppInfo(this.mContext.getPackageName(), this.mContext);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getAppVariantId();
    }

    public Future<Bundle> clearAuthorizationState(APIListener listener) {
        final AuthzCallbackFuture callbackFuture = new AuthzCallbackFuture(listener);
        if (!this.isAPIKeyValid()) {
            callbackFuture.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling clearAuthorizationState");
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AuthError tempError = null;
                try {
                    DatabaseHelper.clearServiceAuthorizationState(AmazonAuthorizationManager.this.mContext);
                }
                catch (AuthError e) {
                    tempError = e;
                }
                finally {
                    DatabaseHelper.clearAuthorizationState(AmazonAuthorizationManager.this.mContext);
                    if (tempError != null) {
                        callbackFuture.onError(tempError);
                    } else {
                        callbackFuture.onSuccess(new Bundle());
                    }
                }
            }
        });
        return callbackFuture;
    }

    public Future<Bundle> getProfile(APIListener listener) {
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getProfile");
        final AuthzCallbackFuture callbackFuture = new AuthzCallbackFuture(listener);
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            @Override
            public void run() {
                if (!AmazonAuthorizationManager.this.isAPIKeyValid()) {
                    callbackFuture.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                    return;
                }
                ProfileHelper.getProfile(AmazonAuthorizationManager.this.mContext, AmazonAuthorizationManager.this.mContext.getPackageName(), new APIListener(){

                    @Override
                    public void onSuccess(Bundle response) {
                        callbackFuture.onSuccess(response);
                    }

                    @Override
                    public void onError(AuthError e) {
                        callbackFuture.onError(e);
                    }
                });
            }
        });
        return callbackFuture;
    }

    private boolean isAPIKeyValid() {
        return this.mAppIdentifier.isAPIKeyValid(this.mContext) ? this.mClientId != null : false;
    }
}

