/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.dataobject;

import android.content.ContentValues;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AbstractDataObject;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.datastore.ProfileDataSource;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class Profile
extends AbstractDataObject {
    private static final String LOG_TAG = Profile.class.getName();
    private static final int EXPIRATION_TIME = 3600000;
    public static final String[] ALL_COLUMNS = new String[]{"Id", "ExpirationTime", "AppId", "Data"};
    protected String mAppFamilyId;
    protected String mData;
    protected Date mExpirationTime;

    public Profile() {
    }

    public Profile(String appFamilyId, String data) {
        this(appFamilyId, data, new Date(Calendar.getInstance().getTime().getTime() + 3600000L));
    }

    Profile(String appId, String data, Date expirationTime) {
        this.mAppFamilyId = appId;
        this.mData = data;
        this.mExpirationTime = expirationTime;
    }

    @Override
    public ContentValues getValuesForInsert() {
        ContentValues to_return = new ContentValues();
        to_return.put(ALL_COLUMNS[COL_INDEX.APP_ID.colId], this.mAppFamilyId);
        if (this.mExpirationTime != null) {
            to_return.put(ALL_COLUMNS[COL_INDEX.EXPIRATION_TIME.colId], DatabaseHelper.ISO8601.format(this.mExpirationTime));
        } else {
            to_return.put(ALL_COLUMNS[COL_INDEX.EXPIRATION_TIME.colId], (String)null);
        }
        to_return.put(ALL_COLUMNS[COL_INDEX.DATA.colId], this.mData);
        return to_return;
    }

    public ProfileDataSource getDataSource(Context context) {
        return ProfileDataSource.getInstance(context);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Profile) {
            try {
                Profile profile = (Profile)obj;
                return TextUtils.equals((CharSequence)this.mAppFamilyId, (CharSequence)profile.getAppFamilyId()) && this.areObjectsEqual(this.mExpirationTime, profile.getExpirationTime()) && this.dataEquals(profile);
            }
            catch (NullPointerException e) {
                MAPLog.e(LOG_TAG, "" + e.toString());
                return false;
            }
        }
        return false;
    }

    public long getId() {
        return this.getRowId();
    }

    public String getAppFamilyId() {
        return this.mAppFamilyId;
    }

    public Date getExpirationTime() {
        return this.mExpirationTime;
    }

    public String getData() {
        return this.mData;
    }

    public Bundle getDataAsBundle() throws AuthError {
        return this.getDataFromJSON();
    }

    public void setId(long id) {
        this.setRowId(id);
    }

    public void setAppId(String appId) {
        this.mAppFamilyId = appId;
    }

    public void setExpirationTime(Date expirationTime) {
        this.mExpirationTime = DatabaseHelper.truncateFractionalSeconds(expirationTime);
    }

    public void setData(String data) {
        this.mData = data;
    }

    @Override
    public String toString() {
        return this.toLogString();
    }

    public String toLogString() {
        return "{ rowid=" + this.getId() + ", appId=" + this.mAppFamilyId + ", expirationTime=" + DatabaseHelper.ISO8601.format(this.mExpirationTime) + ", data=" + this.mData + " }";
    }

    public boolean hasExpired() {
        boolean hasExpired = true;
        if (this.mExpirationTime != null) {
            return this.mExpirationTime.before(Calendar.getInstance().getTime());
        }
        return hasExpired;
    }

    private Bundle getDataFromJSON() throws AuthError {
        Bundle data = new Bundle();
        if (this.mData != null) {
            JSONObject json = null;
            try {
                json = new JSONObject(this.mData);
            }
            catch (JSONException e) {
                MAPLog.e(LOG_TAG, "JSONException while parsing profile information in database", e);
                throw new AuthError("JSONException while parsing profile information in database", e, AuthError.ERROR_TYPE.ERROR_JSON);
            }
            try {
                Iterator keys = json.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = json.getString(key);
                    data.putString(key, value);
                }
            }
            catch (JSONException e) {
                MAPLog.e(LOG_TAG, "Unable to parse profile data in database " + e.getMessage());
            }
        }
        return data;
    }

    private boolean dataEquals(Profile profile) {
        try {
            JSONObject json = new JSONObject(this.mData);
            JSONObject argJSON = new JSONObject(profile.getData());
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = json.getString(key);
                if (value.equals(argJSON.getString(key))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return TextUtils.equals((CharSequence)this.mData, (CharSequence)profile.getData());
        }
    }

    public static enum COL_INDEX {
        ID(0),
        EXPIRATION_TIME(1),
        APP_ID(2),
        DATA(3);

        public final int colId;

        private COL_INDEX(int colId) {
            this.colId = colId;
        }
    }
}

