/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.thread;

import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.thread.DefaultAuthorizationListener;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MAPCallbackFuture
implements Future<Bundle>,
APIListener {
    private static final String MAIN_THREAD_ERROR_MSG = "Cannot call get on the main thread, unless you want ANRs";
    private static final String LOG_TAG = MAPCallbackFuture.class.getName();
    protected final AuthorizationListener mListener;
    protected final CountDownLatch mLatch;
    protected Bundle mSuccessResult;
    protected AuthError mError;

    public MAPCallbackFuture() {
        this(null);
    }

    public MAPCallbackFuture(AuthorizationListener listener) {
        this.mListener = listener == null ? new DefaultAuthorizationListener() : listener;
        this.mLatch = new CountDownLatch(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public Bundle get() throws InterruptedException, ExecutionException {
        this.throwOnMainThread();
        MAPLog.e(LOG_TAG, "Running get on Future");
        this.mLatch.await();
        return this.getResultHelper();
    }

    @Override
    public Bundle get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.throwOnMainThread();
        MAPLog.e(LOG_TAG, "Running get on Future with timeout=" + timeout + "unit=" + unit.name());
        this.mLatch.await(timeout, unit);
        return this.getResultHelper();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.mLatch.getCount() == 0L;
    }

    @Override
    public void onSuccess(Bundle response) {
        this.mSuccessResult = response;
        if (this.mSuccessResult == null) {
            MAPLog.w(LOG_TAG, "Null Response");
            this.mSuccessResult = new Bundle();
        }
        this.mSuccessResult.putSerializable(AuthzConstants.BUNDLE_KEY.FUTURE.val, (Serializable)((Object)AuthzConstants.FUTURE_TYPE.SUCCESS));
        this.mLatch.countDown();
        this.mListener.onSuccess(response);
    }

    @Override
    public void onError(AuthError e) {
        this.mError = e;
        this.mLatch.countDown();
        this.mListener.onError(e);
    }

    protected Bundle getResultHelper() {
        if (this.mError != null) {
            Bundle authErrorBundle = AuthError.getErrorBundle(this.mError);
            authErrorBundle.putSerializable(AuthzConstants.BUNDLE_KEY.FUTURE.val, (Serializable)((Object)AuthzConstants.FUTURE_TYPE.ERROR));
            return authErrorBundle;
        }
        return this.mSuccessResult;
    }

    private void throwOnMainThread() {
        if (ThreadUtils.isRunningOnMainThread()) {
            MAPLog.e(LOG_TAG, MAIN_THREAD_ERROR_MSG);
            throw new IllegalStateException(MAIN_THREAD_ERROR_MSG);
        }
    }
}

