/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.token;

import android.content.Context;
import android.text.TextUtils;
import android.text.format.Time;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.token.Token;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.http.cookie.Cookie;

public class MAPCookie
implements Cookie,
Token,
Serializable {
    private static final String GMT = "GMT";
    private static final String EMPTY_COOKIE = "";
    private static final String COOKIE_NAME_VALUE_SEPERATOR = "=";
    private static final String COOKIE_ATTRIBUTE_SEPERATOR = ";";
    private static final String DOMAIN_PREFIX = "www";
    private static final String DOT = ".";
    public static final int NO_VERSION = -1;
    private static final long serialVersionUID = 551200964665L;
    private static final String LOG_TAG = MAPCookie.class.getName();
    public static final String KEY_HTTP_ONLY = "HttpOnly";
    public static final String KEY_SECURE = "Secure";
    public static final String KEY_EXPIRES = "Expires";
    public static final String KEY_PATH = "Path";
    public static final String KEY_DOMAIN = "Domain";
    public static final String KEY_VALUE = "Value";
    public static final String KEY_NAME = "Name";
    public static final String KEY_COMMENT = "Comment";
    public static final String KEY_COMMENT_URL = "CommentUrl";
    public static final String KEY_VERSION = "Version";
    public static final String KEY_DIRECTED_ID = "DirectedId";
    public static final String KEY_PERSISTANT = "Persistant";
    public static final String COOKIE_DATE_FORMAT = "dd MMM yyyy kk:mm:ss z";
    private final transient Time _localCreationTimestamp = new Time();
    private final Map<String, String> _cookieData;
    private int[] _ports;

    @Override
    public String getType() {
        return this.getName();
    }

    public MAPCookie(String name, String value, String domain, String directedId, boolean isSecure) {
        this._cookieData = new HashMap<String, String>();
        this._cookieData.put(KEY_NAME, name);
        this._cookieData.put(KEY_VALUE, value);
        this._cookieData.put(KEY_DIRECTED_ID, directedId);
        this._cookieData.put(KEY_DOMAIN, domain);
        this.setSecure(isSecure);
        this.logCookie();
    }

    public MAPCookie(Map<String, String> cookieData) throws AuthError {
        this._cookieData = cookieData;
        this.logCookie();
    }

    private void logCookie() {
        MAPLog.pii(LOG_TAG, "Creating Cookie from data. name=" + this.getName(), "domain:" + this.getDomain() + " directedId:" + this.getDirectedId() + " cookie:" + this.getValue());
    }

    public boolean hasExpired() {
        return this.isExpired(Calendar.getInstance().getTime());
    }

    @Override
    public Time getLocalTimestamp() {
        return this._localCreationTimestamp;
    }

    @Override
    public Map<String, String> getData() {
        return this._cookieData;
    }

    @Override
    public String getDirectedId() {
        return this.getAttribute(KEY_DIRECTED_ID);
    }

    public boolean isHttpOnly() {
        String httpOnly = this.getAttribute(KEY_HTTP_ONLY);
        if (TextUtils.isEmpty((CharSequence)httpOnly)) {
            return false;
        }
        return Boolean.getBoolean(httpOnly);
    }

    public void setHttpOnly(boolean httpOnly) {
        this._cookieData.put(KEY_HTTP_ONLY, Boolean.toString(httpOnly));
    }

    public String getComment() {
        return this.getAttribute(KEY_COMMENT);
    }

    public String getCommentURL() {
        return this.getAttribute(KEY_COMMENT_URL);
    }

    public String getDomain() {
        return this.getAttribute(KEY_DOMAIN);
    }

    public Date getExpiryDate() {
        String sExpiryDate = this.getAttribute(KEY_EXPIRES);
        if (sExpiryDate != null) {
            try {
                return MAPCookie.getCookieExpireDate(sExpiryDate);
            }
            catch (ParseException e) {
                MAPLog.e(LOG_TAG, "Date parse error on MAP Cookie", e);
                return null;
            }
        }
        return null;
    }

    public void setExpiryDate(String expiryDate) {
        this.setAttribute(KEY_EXPIRES, expiryDate);
    }

    public String getName() {
        return this.getAttribute(KEY_NAME);
    }

    public String getPath() {
        return this.getAttribute(KEY_PATH);
    }

    public void setPath(String path) {
        this.setAttribute(KEY_PATH, path);
    }

    public int[] getPorts() {
        return this._ports;
    }

    public void setPorts(int[] ports) {
        this._ports = new int[ports.length];
        System.arraycopy(ports, 0, this._ports, 0, ports.length);
    }

    public String getValue() {
        return this.getAttribute(KEY_VALUE);
    }

    public int getVersion() {
        String version = this.getAttribute(KEY_VERSION);
        if (TextUtils.isEmpty((CharSequence)version)) {
            return -1;
        }
        return Integer.parseInt(this.getAttribute(KEY_VERSION));
    }

    public boolean isExpired(Date date) {
        if (this.getExpiryDate() == null) {
            return false;
        }
        if (date == null) {
            date = Calendar.getInstance().getTime();
        }
        return this.getExpiryDate().before(date);
    }

    public boolean isPersistent() {
        return Boolean.parseBoolean(this.getAttribute(KEY_PERSISTANT));
    }

    public boolean isSecure() {
        return Boolean.parseBoolean(this.getAttribute(KEY_SECURE));
    }

    protected void setSecure(boolean isSecure) {
        this.setAttribute(KEY_SECURE, Boolean.toString(isSecure));
    }

    public String getAttribute(String name) {
        return this._cookieData.get(name);
    }

    public String setAttribute(String name, String value) {
        return this._cookieData.put(name, value);
    }

    public static String[] extractCookieStringArray(List<Cookie> cookies) {
        if (cookies != null) {
            ArrayList<String> returnCookies = new ArrayList<String>();
            for (Cookie cookie : cookies) {
                returnCookies.add(MAPCookie.getSetCookieHeader(cookie));
            }
            return returnCookies.toArray(new String[returnCookies.size()]);
        }
        return null;
    }

    public static final String getSetCookieHeader(Cookie cookie) {
        Date date;
        boolean isHttpOnly = false;
        StringBuilder cookieSB = new StringBuilder(cookie.getName().trim());
        cookieSB.append(COOKIE_NAME_VALUE_SEPERATOR);
        cookieSB.append(cookie.getValue().trim());
        cookieSB.append("; path=/");
        cookieSB.append("; domain=" + cookie.getDomain().trim());
        if (cookie.isSecure()) {
            cookieSB.append("; secure");
        }
        if ((date = cookie.getExpiryDate()) != null) {
            cookieSB.append("; expires=");
            if (date.before(Calendar.getInstance().getTime())) {
                MAPLog.i(LOG_TAG, "Cookie " + cookie.getName() + " expired : " + date);
            }
            cookieSB.append(MAPCookie.formatDate(date));
        }
        return cookieSB.toString();
    }

    private static final String getClearSetCookieHeader(Cookie cookie) {
        Date date;
        boolean isHttpOnly = false;
        StringBuilder cookieSB = new StringBuilder(cookie.getName().trim());
        cookieSB.append(COOKIE_NAME_VALUE_SEPERATOR);
        cookieSB.append(EMPTY_COOKIE);
        cookieSB.append("; path=/");
        cookieSB.append("; domain=" + cookie.getDomain().trim());
        if (cookie.isSecure()) {
            cookieSB.append("; secure");
        }
        if ((date = cookie.getExpiryDate()) != null) {
            cookieSB.append("; expires=");
            if (date.before(Calendar.getInstance().getTime())) {
                MAPLog.i(LOG_TAG, "Cookie " + cookie.getName() + " expired : " + date);
            }
            cookieSB.append(MAPCookie.formatDate(date));
        }
        return cookieSB.toString();
    }

    public static String getCookiesStringFromCookieManager(Context context, String domain) {
        CookieSyncManager manager = null;
        try {
            manager = CookieSyncManager.getInstance();
        }
        catch (IllegalStateException e) {
            MAPLog.i(LOG_TAG, "CookieSyncManager not yet created... creating");
            CookieSyncManager.createInstance((Context)context);
            manager = CookieSyncManager.getInstance();
        }
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        manager.sync();
        String getCookieDomain = domain;
        if (getCookieDomain.startsWith(DOT)) {
            getCookieDomain = DOMAIN_PREFIX + getCookieDomain;
        }
        String cookies = cookieManager.getCookie(getCookieDomain);
        MAPLog.i(LOG_TAG, "Extracting cookies from CookieManager for domain=" + getCookieDomain);
        return cookies;
    }

    public static List<Cookie> getCookiesFromCookieManager(Context context, String domain, String directedId) throws AuthError {
        String cookies = MAPCookie.getCookiesStringFromCookieManager(context, domain);
        MAPLog.pii(LOG_TAG, "Extracting cookie list for domain=" + domain, "directedId=" + directedId);
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        if (cookies != null) {
            StringTokenizer cookiesParser = new StringTokenizer(cookies, COOKIE_ATTRIBUTE_SEPERATOR);
            while (cookiesParser.hasMoreTokens()) {
                String cookie = cookiesParser.nextToken();
                StringTokenizer cookieParser = new StringTokenizer(cookie.trim(), COOKIE_NAME_VALUE_SEPERATOR);
                if (!cookieParser.hasMoreTokens()) continue;
                String cookieName = cookieParser.nextToken();
                String cookieValue = EMPTY_COOKIE;
                if (cookieParser.hasMoreTokens()) {
                    cookieValue = cookieParser.nextToken();
                }
                cookieList.add(new MAPCookie(cookieName, cookieValue, domain, directedId, false));
            }
        } else {
            MAPLog.i(LOG_TAG, "No cookies in Cookie manager for " + domain);
        }
        return cookieList;
    }

    private static Date getCookieExpireDate(String expiryDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(COOKIE_DATE_FORMAT, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone(GMT));
        return format.parse(expiryDate);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(COOKIE_DATE_FORMAT, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone(GMT));
        return format.format(date);
    }

    public static void clearCookieInCookieManager(Context context, Cookie cookie, String url, String directedId) throws AuthError {
        CookieSyncManager manager = null;
        try {
            manager = CookieSyncManager.getInstance();
        }
        catch (IllegalStateException e) {
            MAPLog.i(LOG_TAG, "CookieSyncManager not yet created... creating");
            CookieSyncManager.createInstance((Context)context);
            manager = CookieSyncManager.getInstance();
        }
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        manager.sync();
        String cookieString = MAPCookie.getClearSetCookieHeader(cookie);
        cookieManager.setCookie(url, cookieString);
        manager.sync();
    }

    private class CookieAttribute {
        private static final String EXPIRES = "; expires=";
        private static final String HTTP_ONLY = "; httponly";
        private static final String SECURE = "; secure";
        private static final String DOMAIN = "; domain=";
        private static final String PATH = "; path=/";

        private CookieAttribute() {
        }
    }
}

