/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiMap<K, V> {
    private final Map<K, Set<V>> _multiMap = new HashMap<K, Set<V>>();

    public boolean put(K key, V value) {
        Set<V> values = this._multiMap.get(key);
        if (values == null) {
            values = new HashSet<V>();
            this._multiMap.put(key, values);
        }
        return values.add(value);
    }

    public Set<K> getKeys() {
        return Collections.unmodifiableSet(this._multiMap.keySet());
    }

    public Set<V> getValues(K key) {
        Set<V> values = this._multiMap.get(key);
        if (values == null) {
            values = new HashSet<V>();
        }
        return Collections.unmodifiableSet(values);
    }

    public void clear() {
        this._multiMap.clear();
    }

    public int size() {
        int size = 0;
        Set<K> keys = this.getKeys();
        for (K key : keys) {
            size += this.getValues(key).size();
        }
        return size;
    }

    public boolean addAll(K key, Set<V> valueSet) {
        Set<V> values = this._multiMap.get(key);
        if (values == null) {
            values = new HashSet<V>();
            this._multiMap.put(key, values);
        }
        return values.addAll(valueSet);
    }
}

